/*
 * Начальное заполнение формы
 */
function fillform(netinfo){

	if(document.getElementById("ip") != null)
		document.getElementById("ip").value = netinfo["ip"];	
	
	if(document.getElementById("mask") != null)
		document.getElementById("mask").value = netinfo["mask"];
	
	if(document.getElementById("dns") != null)
		document.getElementById("dns").value = netinfo["dns"];
	
	if(document.getElementById("gateway") != null)
		document.getElementById("gateway").value = netinfo["gate"];

	if(document.getElementById("dhcp") != null)
		document.getElementById("dhcp").checked = netinfo["dhcp"];
	
	if(netinfo["wifi"] != null)
		document.getElementById("wifi").checked = netinfo["wifi"];
	
	if(netinfo["ssid"]!= null)
		document.getElementById("ssid").value = netinfo["ssid"];
	
	if( netinfo["psw"])
		document.getElementById("pasw").value = netinfo["psw"];

}


/*
 * Начать регистрацию
 */
function store_param_net(){
	if(check_entering_data() == true){
		var v_ip =  document.getElementById("ip").value;
		var v_mask = document.getElementById("mask").value;
		var v_gate = document.getElementById("gateway").value;
		var v_dns = document.getElementById("dns").value;
		var v_dhcp = (document.getElementById("dhcp").checked == true) ? 1 : 0;
		var v_wifi = (document.getElementById("wifi").checked == true) ? 1 : 0;
		var v_ssid = document.getElementById("ssid").value;
		var v_pasw = document.getElementById("pasw").value;

		pasw = ""
		for (var n = 0; n<v_pasw.length; ++n){
			if(v_pasw[n] == '#')pasw+='@@';
			else pasw+=v_pasw[n];
		}
		
		
		var str_new_fninfo = "/?ajax_store_info_net??"+
		v_ip+"??"+
		v_mask+"??"+
		v_gate+"??"+
		v_dns+"??"+
		v_dhcp+"??"+
		v_wifi+"??"+
		v_ssid+"??"+
		pasw;
		
		//alert(str_new_fninfo);
		
		changeInterval(50);
		setRequest(function (){		
			return str_new_fninfo;
		});
	}else{
		
	}
}

/*
 * Проверка на числа 
 */
function check_on_digits(text){
	return (isNaN(parseInt(text)) == false) ? true : false;
}

//Проверка IP поля
function check_on_ip(val){
	var filds = val.split(".");
	
	if(filds.length != 4)
		return false;
	
	for(var i=0; i<4; ++i){
		if(check_on_digits(filds[i]) == false || parseInt(filds[i]) > 255) return false;
	}
	
	return true;
}

/*
 * Проверить введенные данные
 */
function check_entering_data(){
	var v_ip =  document.getElementById("ip").value;
	var v_mask = document.getElementById("mask").value;
	var v_gate = document.getElementById("gateway").value;
	var v_dns = document.getElementById("dns").value;
	var v_dhcp = (document.getElementById("dhcp").checked == true) ? 1 : 0;
	
	
	if(check_on_ip(v_ip) == false){
		draw_error("Ошибка", "Неверно оформлено поле  'IP' ");
		return false;
	}else if(check_on_ip(v_mask) == false){
		draw_error("Ошибка", "Неверно оформлено поле  'Маска' ");
		return false;
	}else if(check_on_ip(v_gate) == false){
		draw_error("Ошибка", "Неверно оформлено поле  'Шлюз' ");
		return false;
	}else if(check_on_ip(v_dns) == false){
		draw_error("Ошибка", "Неверно оформлено поле  'DNS' ");
		return false;
	}  
	
	return true;
} 

/*
 * Обработчик ajax событий 
 */
function local_proc(values){

	if(values[0] == "rez_store_info_net"){
		if(values[1] == "Fault"){
			draw_error("Ошибка", "<p>"+values[3] + "</p><strong>"+values[2]+"</strong>");
		}
		 else{
			draw_info("Данные успешно сохранены. <p>Для применения данных требуется перезагрузка ККТ.<p>");
		}
	}
	changeInterval(750);	
}


var fun_end_error = null;
function draw_error(title, info, fexit){
	var dlg = document.getElementById("dialog_error");
	dlg.style.display = "block";
	
	var head1 = document.getElementById("title_error_dialog");
	head1.innerHTML = title;
	
	var info1 = document.getElementById("error_info");
	info1.innerHTML = info;
	
	fun_end_error = fexit;
}

function close_dialog_error(){
	var dlg = document.getElementById("dialog_error");
	dlg.style.display = "none";
	
	if(fun_end_error != null){
		fun_end_error();
		fun_end_error = null;
	}
}

function draw_info(info){
	var dlg = document.getElementById("dlg-info");
	dlg.style.display = "block";
	
	
	var info1 = document.getElementById("el_info");
	info1.innerHTML = info;
	
}

function close_dialog_info(){
	var dlg = document.getElementById("dlg-info");
	dlg.style.display = "none";
	
}

function need_reset(){
	setRequest(function (){
		window.location.href = "entrance.html";
		return "/?ajax_need_reset";
	});

	
}
