
function prepare_table(){
	var root_element = document.getElementById("contain_tax");
	
	while (root_element.lastChild){			
		root_element.removeChild(root_element.lastChild);
	}
	
	var element_tr = document.createElement("tr");
	root_element.appendChild(element_tr);
	
	var e_th = document.createElement("th");
	e_th.innerHTML = "№";
	element_tr.appendChild(e_th);

	var e_th1 = document.createElement("th");
	e_th1.innerHTML = "Используемый налог";
	element_tr.appendChild(e_th1);


	var e_th1_tax = document.createElement("th");
	e_th1_tax.innerHTML = "Ставка";
	element_tr.appendChild(e_th1_tax);

	var e_sno = document.createElement("th");
	e_sno.innerHTML = "СНО";
	element_tr.appendChild(e_sno);

	
	var e_th2 = document.createElement("th");
	e_th2.innerHTML = "Наименование(для печати)";
	element_tr.appendChild(e_th2);
	
	var e_th5 = document.createElement("th");
	element_tr.appendChild(e_th5);

	var head_table = document.getElementById("head_table");
	
	if(head_table.innerHTML == "No"){
		head_table.innerHTML = "";
		var img_head = document.createElement("img");
		img_head.setAttribute("src", "images/edit_tax_logo.png");
		
		head_table.appendChild(img_head);
		//<!--  <img src="images/edit_user_logo.png"/> -->
	}
	
	return root_element;
}

var name_tax_18 =   {  "DONOT_TAXED" : "НДС не облагается",
		"INCLUDING_TAX_18" : "Ставка НДС расч. 18%/118%",
		"INCLUDING_TAX_10" : "Ставка НДС расч. 10%/110%",
		"INCLUDING_TAX_0"  : "Ставка НДС 0%",
		"ACCRUED_TAX_10"   : "Ставка НДС 10%",
		"ACCRUED_TAX_18"   : "Ставка НДС 18%"};

var name_tax_20 =   {  "DONOT_TAXED" : "НДС не облагается",
"INCLUDING_TAX_18" : "Ставка НДС расч. 20%/120%",
"INCLUDING_TAX_10" : "Ставка НДС расч. 10%/110%",
"INCLUDING_TAX_0"  : "Ставка НДС 0%",
"ACCRUED_TAX_10"   : "Ставка НДС 10%",
"ACCRUED_TAX_18"   : "Ставка НДС 20%"};

var name_tax = name_tax_20;

var name_sno =   {  0 : "СНО ОСН",
		1 : "СНО УСН ДОХОД",
		2 : "СНО УСН ДОХОД-РАСХОД",
		3  : "СНО ЕНВД",
		4   : "СНО ЕСХН",
		5   : "СНО ПАТЕНТ"};


function filltable(tax){
	var root_element = prepare_table();
	if(year <= 2018){
		name_tax = name_tax_18;
	}else{
		name_tax = name_tax_20;
	}

	for(var i = 0; i<tax.length; i++){
		var row_element = document.createElement("tr");
		var st = "id_tax_"+i;

		var val = tax[i]["val"];
		
		if(val == 18 && year > 2018){
			val = 20;
		}

		
		row_element.setAttribute("id", st);
		root_element.appendChild(row_element);

		var td_num = document.createElement("th")
		td_num.setAttribute("class", "sub");
		row_element.appendChild(td_num);
		td_num.innerHTML = ""+(i+1)+".";
		
		var td_tax_info = document.createElement("td")
		row_element.appendChild(td_tax_info);
		td_tax_info.innerHTML = name_tax[tax[i]["tax"]];

		var td_tax_val = document.createElement("td")
		row_element.appendChild(td_tax_val);
		if(tax[i]["val"] != null){
			td_tax_val.innerHTML = val; 
		}else{
			td_tax_val.innerHTML = 0;
		}

		var td_sno_val = document.createElement("td")
		row_element.appendChild(td_sno_val);
		if(tax[i]["sno"] != null){
			td_sno_val.innerHTML = name_sno[tax[i]["sno"]]; 
		}else{
			td_sno_val.innerHTML = 0;
		}

		
		var td_name = document.createElement("td")
		row_element.appendChild(td_name);
		td_name.innerHTML = tax[i]["text"];
		
		// <img style=\"cursor: pointer;\" onClick=\"edit_device(%d)\" src=\"img/edit.png\"/>"
		var td_edit = document.createElement("td")
		td_edit.setAttribute("align", "center");
		row_element.appendChild(td_edit);
		var img_edit = document.createElement("img");
		img_edit.setAttribute("src", "images/pencil22.png");
		img_edit.setAttribute("style", "cursor: pointer;");
		img_edit.setAttribute("onClick", "start_edit_tax("+i+")");
		td_edit.appendChild(img_edit);
	}
}




var old_login = "";
var new_user = null;
function start_edit_tax(num){
	if(year <= 2018){		
		document.getElementById("t118_120").innerHTML = "Ставка НДС расч. 18%/118%";
		document.getElementById("t18_20").innerHTML = "Ставка НДС 18%";
	}

	
	var tax = extra_tax["tax"][num];

	var el_secnum  = document.getElementById("secnum");
	el_secnum.innerHTML = "" + (num+1);

	var edit_user = document.getElementById("edit_tax");
	edit_user.style.display = "block";

	
	var el_taxinfo = document.getElementById("taxinfo");
	el_taxinfo.value = tax['tax'];

	var el_taxval = document.getElementById("taxval");
	var val = tax['val'];
	if(val == 18 && year > 2018){
		val = 20;
	}
	el_taxval.value = val;

	var el_sno = document.getElementById("sno");
	el_sno.value = ""+tax['sno'];
	
	var el_text = document.getElementById("textinfo");
	el_text.value = tax["text"];
}

function changeTax(){
	var Sel = document.getElementById("taxinfo").value;
	var Tax = document.getElementById("taxval");
	if(Sel == "DONOT_TAXED"){
		Tax.value = 0;
	}else if(Sel == "INCLUDING_TAX_18"){
		Tax.value = (year <= 2018) ? 18 : 20;
	}else if(Sel == "INCLUDING_TAX_10"){
		Tax.value = 10;
	}else if(Sel == "INCLUDING_TAX_0"){
		Tax.value = 0;
	}else if(Sel == "ACCRUED_TAX_10"){
		Tax.value = 10;
	}else if(Sel == "ACCRUED_TAX_18"){
		Tax.value = (year <= 2018) ? 18 : 20;
	}
}

function cancel_edit_tax(){
	var edit_user = document.getElementById("edit_tax");
	edit_user.style.display = "none";	
}

var send_str = "";
function end_edit_tax(){
	var el_secnum = document.getElementById("secnum");
	var secnum = el_secnum.innerHTML; 
	
	var el_text = document.getElementById("textinfo");
	var textinfo = el_text.value;
	
	var el_tax = document.getElementById("taxinfo");
	var taxinfo = el_tax.value;

	var el_val = document.getElementById("taxval");
	var valinfo = el_val.value;

	var el_sno = document.getElementById("sno");
	var valsno = el_sno.value;

	
	var edit_tax = document.getElementById("edit_tax");
	edit_tax.style.display = "none";	
	
	send_str = "/?ajax_edit_tax??"+(parseInt(secnum)-1)+"??"+taxinfo+"??"+valinfo+"??"+textinfo+"??"+valsno;
	new_tax = {
			"num":parseInt(secnum),
			"tax":taxinfo,
			"val":parseInt(valinfo),
			"text":textinfo,
			"sno" : parseInt(valsno),
		};	
	
	
	extra_tax["tax"][parseInt(secnum)-1] = new_tax;
	
	setRequest(function (){
		var S = send_str;
		return S;
	});
}


function close_dialog_select(){
	var dlg_delete = document.getElementById("dlg-select");
	dlg_delete.style.display = "none";	
}

function delete_user(){
	var dlg_delete = document.getElementById("dlg-select");
	dlg_delete.style.display = "none";	
	send_str = "/?ajax_delete_user??"+old_login;
	
	setRequest(function (){
		var S = send_str;
		return S;
	});

}

function local_proc(values){
	//alert(values);
	if(values[0] == "rez_edit_tax"){
		if(values[1] == "OK"){
				filltable(extra_tax["tax"]);
				
				document.getElementById("div_need_reset").style.display  = "block";
		}else{
			draw_error("Ошибка", "Ошибка при изменении параметров секции.",null);
		}
	}
}

var fun_end_error = null;
function draw_error(title, info, fexit){
	var dlg = document.getElementById("dialog_error");
	dlg.style.display = "block";
	
	var head1 = document.getElementById("title_error_dialog");
	head1.innerHTML = title;
	
	var info1 = document.getElementById("error_info");
	info1.innerHTML = info;
	
	fun_end_error = fexit;
}

function close_dialog_error(){
	var dlg = document.getElementById("dialog_error");
	dlg.style.display = "none";
	
	if(fun_end_error != null){
		fun_end_error();
		fun_end_error = null;
	}
}


function need_reset(){
	setRequest(function (){
		window.location.href = "entrance.html";
		return "/?ajax_need_reset";
	});
}